<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CWidgetsWidgetLinks extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "3",
		"name"	=> "Links",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		if (!is_array($widget)) {
			return "";
		}

		$links = $this->module->GetStaticItems($widget);

		if (!is_array($links)) {
			return "";
		}
	
		
		global $base;
	
		foreach ($links as $key => $val) {

			$more = $this->plugins["modules"]->BuildLink(array(
				"type"	=> $val["item_link_type"],
				"link"	=> $val["item_link_link"],
				"module"=> $val["item_link_module"],
				"global"=> $val["item_link_global"]
			));

			switch ($val["item_link_type"]) {
				case "2":
					$links[$key]["selected"] = $_GET["module_id"] == $val["item_link_module"] ? $this->tpl->blockReplace("Selected") : "";
				break;

				case "3":
					$mod = $this->plugins["modules"]->GetGlobalModuleById($val["item_link_global"]);
					$links[$key]["selected"] = $_GET["mod"] == $mod["module_code"] ? $this->tpl->blockReplace("Selected") : "";
				break;

			}
			
			
			$links[$key]["link"] = $more;
			$links[$key]["icon"] = $this->tpl->blockReplace($val["item_link_icon"] ? "Icon" : "NoIcon", $val);


			if ($val["item_link_type"]) {

				if ($more) {
					$links[$key]["content"] = $this->tpl->blockExists("Link") ? $this->tpl->blockReplace("Link" , $links[$key]) : "";
				} else {
					unset($links[$key]);
				}
				
			} else {
				$links[$key]["content"] = $this->tpl->blockExists("NoLink") ?  $this->tpl->blockReplace("NoLink" , $links[$key]) : "";
			}
						
			
		}

		
		return $this->tpl->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->table(
					$this->tpl, 
					"",	
					$links
				)
			),
			$widget ,
			array(
				"selected"	=> ""
			)
		);

	}
	

}


?>